// Landscape.h: Schnittstelle fr die Klasse CLandscape.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_LANDSCAPE_H__5D8FD502_79AF_11D1_8F4C_206373C10800__INCLUDED_)
#define AFX_LANDSCAPE_H__5D8FD502_79AF_11D1_8F4C_206373C10800__INCLUDED_

#include "Texture.h"	// Hinzugefgt von der Klassenansicht
#include "Triangle.h"
#include <math.h>

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

// Size of the surface & triangle array
// (a size of 100 is enough to hold 20K polygons)
#define ARRAY_SIZE 100

class CLandscape  
{
public:
	CTexture m_Texture;
	void DrawLandscape();
	void GenerateLandscape(int iListIndex);
	CLandscape();
	virtual ~CLandscape();
	// Calculated range
	float m_XMin;
	float m_XMax;
	float m_YMin;
	float m_YMax;
	// Point in Mandelbrot set
	float m_CX;
	float m_CY;
	// Distance between two calculated points (accurancy)
	float m_StepSize; 
	// How often the iteration for one point will be repeated
	unsigned short int m_IterationDepth;
	// Which value a point must overstep to be part of the Julia set
	unsigned long m_Limit;
	// Which value a point must overstep to be drawn
	float m_MinimumHeight;
	// Brightness adjustment
	float m_Brightness;
	// Collision detection array with all landscape triangles in it
	CTriangle *m_Triangles;
	// How many triangles exists in the collision detection array
	long int m_TriangleCount;
private:
	void SetBottomVertices(float fTriangle[][3]);
	bool IsAboveCriticalHeight(float fTriangle[][3]);
	// Function for generating the fractal
	void CalculateFractalLandscape(short int &iArrayWidth, short int &iArrayHeight, float m_Surface[][ARRAY_SIZE]);
	// Index for display list
	unsigned int m_LandscapeList;
};

#endif // !defined(AFX_LANDSCAPE_H__5D8FD502_79AF_11D1_8F4C_206373C10800__INCLUDED_)
